unit VCTRAN32;{Feb14/97 9:30am}

interface

uses WinTypes, VCType32;

function VCLoadVCTRAN32 : boolean;
procedure VCFreeVCTRAN32;
procedure VCAcadBlockRead(pName: PChar); stdcall;
procedure VCAcadRead(pN: PChar); stdcall;
procedure VCAcadReadNoPaint(pNameStart: PChar); stdcall;
procedure VCAcadReadWith3D(pName: PChar); stdcall;
procedure VCAcadWriteDWG(pN: PChar); stdcall;
procedure VCAcadWriteDXF(pN: PChar); stdcall;
procedure VCLoadDrawing(var iError: smallint; pName: PChar; iFileType: smallint); stdcall;
procedure VCMergeDrawing(var iError: smallint; pName: PChar; iFileType: smallint); stdcall;
procedure VCMergeDrawingNoPaint(var iError: smallint; pInputName: PChar; iFileType: smallint); stdcall;
procedure VCSaveDrawing(var iError: smallint; pName: PChar; iFileType: smallint; tfSaveSelected: wordbool); stdcall;
procedure VCWriteMetafile(pName: PChar; iFileType: smallint; tfSelectedOnly: wordbool); stdcall;

implementation

var
    hInst : THandle;

function VCLoadVCTRAN32 : boolean;
begin
  hInst := LoadLibrary('VCTRAN32.DLL');
  result := hInst >= 32;
end;

procedure VCFreeVCTRAN32;
begin
  FreeLibrary(hInst);
end;

type TVCAcadBlockRead = procedure (pName: PChar); stdcall;

procedure VCAcadBlockRead (pName: PChar);
var aproc : TVCAcadBlockRead;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAcadBlockRead');
  if @aproc <> nil then
      aproc(pName);
end;

type TVCAcadRead = procedure (pN: PChar); stdcall;

procedure VCAcadRead (pN: PChar);
var aproc : TVCAcadRead;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAcadRead');
  if @aproc <> nil then
      aproc(pN);
end;

type TVCAcadReadNoPaint = procedure (pNameStart: PChar); stdcall;

procedure VCAcadReadNoPaint (pNameStart: PChar);
var aproc : TVCAcadReadNoPaint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAcadReadNoPaint');
  if @aproc <> nil then
      aproc(pNameStart);
end;

type TVCAcadReadWith3D = procedure (pName: PChar); stdcall;

procedure VCAcadReadWith3D (pName: PChar);
var aproc : TVCAcadReadWith3D;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAcadReadWith3D');
  if @aproc <> nil then
      aproc(pName);
end;

type TVCAcadWriteDWG = procedure (pN: PChar); stdcall;

procedure VCAcadWriteDWG (pN: PChar);
var aproc : TVCAcadWriteDWG;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAcadWriteDWG');
  if @aproc <> nil then
      aproc(pN);
end;

type TVCAcadWriteDXF = procedure (pN: PChar); stdcall;

procedure VCAcadWriteDXF (pN: PChar);
var aproc : TVCAcadWriteDXF;
begin
  @aproc :=  GetProcAddress(hInst, 'VCAcadWriteDXF');
  if @aproc <> nil then
      aproc(pN);
end;

type TVCLoadDrawing = procedure (var iError: smallint; pName: PChar; iFileType: smallint); stdcall;

procedure VCLoadDrawing (var iError: smallint; pName: PChar; iFileType: smallint);
var aproc : TVCLoadDrawing;
begin
  @aproc :=  GetProcAddress(hInst, 'VCLoadDrawing');
  if @aproc <> nil then
      aproc(iError, pName, iFileType);
end;

type TVCMergeDrawing = procedure (var iError: smallint; pName: PChar; iFileType: smallint); stdcall;

procedure VCMergeDrawing (var iError: smallint; pName: PChar; iFileType: smallint);
var aproc : TVCMergeDrawing;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMergeDrawing');
  if @aproc <> nil then
      aproc(iError, pName, iFileType);
end;

type TVCMergeDrawingNoPaint = procedure (var iError: smallint; pInputName: PChar; iFileType: smallint); stdcall;

procedure VCMergeDrawingNoPaint (var iError: smallint; pInputName: PChar; iFileType: smallint);
var aproc : TVCMergeDrawingNoPaint;
begin
  @aproc :=  GetProcAddress(hInst, 'VCMergeDrawingNoPaint');
  if @aproc <> nil then
      aproc(iError, pInputName, iFileType);
end;

type TVCSaveDrawing = procedure (var iError: smallint; pName: PChar; iFileType: smallint; tfSaveSelected: wordbool); stdcall;

procedure VCSaveDrawing (var iError: smallint; pName: PChar; iFileType: smallint; tfSaveSelected: wordbool);
var aproc : TVCSaveDrawing;
begin
  @aproc :=  GetProcAddress(hInst, 'VCSaveDrawing');
  if @aproc <> nil then
      aproc(iError, pName, iFileType, tfSaveSelected);
end;

type TVCWriteMetafile = procedure (pName: PChar; iFileType: smallint; tfSelectedOnly: wordbool); stdcall;

procedure VCWriteMetafile (pName: PChar; iFileType: smallint; tfSelectedOnly: wordbool);
var aproc : TVCWriteMetafile;
begin
  @aproc :=  GetProcAddress(hInst, 'VCWriteMetafile');
  if @aproc <> nil then
      aproc(pName, iFileType, tfSelectedOnly);
end;


end.